/*
  Qtechknow Creator Kit: Circuit 5 - TempSensor
  
  Reads the temperature value from the TMP36 temperature
  sensor.
 
  created by Quin Etnyre
  made on 10 July 15
*/

int tempPin = A0; // analog pin

void setup() {
  
  Serial.begin(9600);  // open Serial port
  
  while(!Serial);  // wait until Serial monitor is open
  
}


void loop() {
  
  int value = analogRead(tempPin);
  
  Serial.print(value); Serial.print(" > ");
  
  float millivolts = (value / 1024.0) * 5000;
  // sensor output is 10mV per degree Celsius
  float celsius = millivolts / 10;
  // post degrees in Celsius to the Serial monitor
  Serial.print(celsius);
  Serial.print(" degrees Celsius, ");
  // post degrees in Fahrenheit to the Serial monitor
  Serial.print( (celsius * 9)/ 5 + 32 );
  Serial.println(" degrees Fahrenheit");

  delay(1000); // wait for one second until next reading
}
      
    
